%Example: Run a simulation with a heavy-duty conventional vehicle
clear

% Paths
addpath('algo\')
addpath('models\')
addpath('dataIO\')
addpath('visualization\')

%% Create a vehicle configuration, load the mission
conf = vehConf('bev');

% Replace some components
conf.vehicle_name = "daily_bev";
conf.em_name = "ldv125";
conf.battery_name = "LFP_cell_26605P";

% Battery pack specifics (IVECO daily data online https://edaily.iveco.com/it-IT/)
rescaled_batt_voltage = 360; %V (assumed, not found online)
rescaled_batt_energy = 111; %kWh
rescaled_em_ratedPower = 140; % kW

% Case scenarios  
% Select the mission. This must be an existing .mat file in the library
mission_name_array = ["AUDC"]; % RegionalDelivery, LongHaul


for mission_name = mission_name_array
    % Create the vehicle data using createConfiguration
    veh = createVehicle(conf);

    veh.batt = scaleBatt(veh.batt, rescaled_batt_energy, rescaled_batt_voltage);
    veh.batt.actualCap = veh.batt.nomCap;
    
    veh.em = scaleEMachine(veh.em, rescaled_em_ratedPower);

    
    %% Run simulation
    [results, veh, prof, info] = vehicleSim(veh, mission_name);
    
    %% Plot
    % Main profiles
    mainProfiles(prof, veh);
    
    % Plot default profiles as a function of traveled distance
    BattProfile(veh.batt, prof)
    
    % E motor
    emMapOperation(veh.em, prof)
    
    
    %% Store results
    [~, mission_name] = fileparts(mission_name);
    saveName = join([mission_name], '_');
        dest_folder = fullfile('Results','BattCurrProfile');   if exist(dest_folder,'dir')~=7, mkdir(dest_folder),end 
    save(fullfile(dest_folder,saveName), 'results', 'veh', 'prof', 'info');
end
